<?php
/**
 * Blog setting for Customizer
 *
 * @package surince
 * @version 3.8.9
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Blog Posts General
$this->sections['surince_blog_post'] = array(
	'title' => esc_html__( 'General', 'surince' ),
	'panel' => 'surince_blog',
	'settings' => array(
		array(
			'id' => 'blog_featured_title',
			'default' => esc_html__( 'Our Blog', 'surince' ),
			'control' => array(
				'label' => esc_html__( 'Blog Featured Title', 'surince' ),
				'type' => 'text',
			),
		),
		array(
			'id' => 'blog_entry_content_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Entry Content Background Color', 'surince' ),
			),
			'inline_css' => array(
				'target' => '.post-content-wrap',
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'blog_entry_content_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Entry Content Padding', 'surince' ),
				'description' => esc_html__( 'Top Right Bottom Left.', 'surince' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-content-wrap',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'blog_entry_bottom_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Entry Bottom Margin', 'surince' ),
				'description' => esc_html__( 'Example: 30px.', 'surince' ),
			),
			'inline_css' => array(
				'target' => '.hentry',
				'alter' => 'margin-top',
			),
		),
		array(
			'id' => 'blog_entry_border_width',
			'transport' => 'postMessage',
			'control' => array (
				'type' => 'text',
				'label' => esc_html__( 'Entry Border Width', 'surince' ),
				'description' => esc_html__( 'Top Right Bottom Left. Example: 0px 2px 0px 0px', 'surince' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-content-wrap',
				'alter' => 'border-width',
			),
		),
		array(
			'id' => 'blog_entry_border_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Entry Border Color', 'surince' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-content-wrap',
				'alter' => 'border-color',
			),
		),
		array(
			'id' => 'blog_entry_composer',
			'default' => 'meta,title,excerpt_content,readmore',
			'control' => array(
				'label' => esc_html__( 'Entry Content Elements', 'surince' ),
				'type' => 'surince-sortable',
				'object' => 'Surince_Customize_Control_Sorter',
				'choices' => array(
					'meta'            => esc_html__( 'Meta', 'surince' ),
					'title'           => esc_html__( 'Title', 'surince' ),
					'excerpt_content' => esc_html__( 'Excerpt', 'surince' ),
					'readmore'        => esc_html__( 'Read More', 'surince' ),

				),
				'desc' => esc_html__( 'Drag and drop elements to re-order.', 'surince' ),
			),
		),
	),
);

// Blog Posts Media
$this->sections['surince_blog_post_media'] = array(
	'title' => esc_html__( 'Blog Post - Media', 'surince' ),
	'panel' => 'surince_blog',
	'settings' => array(
		array(
			'id' => 'blog_media_margin_bottom',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Bottom Margin', 'surince' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-media',
				'alter' => 'margin-bottom',
			),
		),
	),
);

// Blog Posts Title
$this->sections['surince_blog_post_title'] = array(
	'title' => esc_html__( 'Blog Post - Title', 'surince' ),
	'panel' => 'surince_blog',
	'settings' => array(
		array(
			'id' => 'blog_title_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Margin', 'surince' ),
				'description' => esc_html__( 'Top Right Bottom Left.', 'surince' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-title',
				'alter' => 'margin',
			),
		),
		array(
			'id' => 'blog_title_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'surince' ),
			),
			'inline_css' => array(
				'target' => array(
					'.hentry .post-title a',
				),
				'alter' => 'color',
			),
		),
		array(
			'id' => 'blog_title_color_hover',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color Hover', 'surince' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-title a:hover',
				'alter' => 'color',
			),
		),
	),
);

// Blog Posts Meta
$this->sections['surince_blog_post_meta'] = array(
	'title' => esc_html__( 'Blog Post - Meta', 'surince' ),
	'panel' => 'surince_blog',
	'settings' => array(
		array(
			'id' => 'blog_meta_style',
			'default' => 'simple',
			'control' => array(
				'label'  => esc_html__( 'Style', 'surince' ),
				'type' => 'select',
				'choices' => array(
					'simple' => esc_html__( 'Simple', 'surince' ),
					'style-2' => esc_html__( 'Style 2', 'surince' ),
				)
			),
		),
		array(
			'id' => 'blog_before_author',
			'default' => esc_html__( 'by', 'surince' ),
			'control' => array(
				'label' => esc_html__( 'Text Before Author', 'surince' ),
				'type' => 'text',
			),
		),
		array(
			'id' => 'blog_before_category',
			'default' => esc_html__( 'in', 'surince' ),
			'control' => array(
				'label' => esc_html__( 'Text Before Category', 'surince' ),
				'type' => 'text',
			),
		),
		array(
			'id' => 'blog_entry_meta_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Meta Margin', 'surince' ),
				'description' => esc_html__( 'Top Right Bottom Left. Example: 0 0 20px 0.', 'surince' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-meta',
				'alter' => 'margin',
			),
		),
		array(
			'id'  => 'blog_entry_meta_items',
			'default' => array( 'author', 'comments', 'date', 'categories' ),
			'control' => array(
				'label' => esc_html__( 'Meta Items', 'surince' ),
				'desc' => esc_html__( 'Click and drag and drop elements to re-order them.', 'surince' ),
				'type' => 'surince-sortable',
				'object' => 'Surince_Customize_Control_Sorter',
				'choices' => array(
					'author'     => esc_html__( 'Author', 'surince' ),
					'comments' => esc_html__( 'Comments', 'surince' ),
					'date'       => esc_html__( 'Date', 'surince' ),
					'categories' => esc_html__( 'Categories', 'surince' ),
				),
			),
		),
		array(
			'id' => 'heading_blog_entry_meta_item',
			'control' => array(
				'type' => 'surince-heading',
				'label' => esc_html__( 'Item Meta', 'surince' ),
			),
		),
		array(
			'id' => 'blog_entry_meta_item_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Text Color', 'surince' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-meta .item',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'blog_entry_meta_item_link_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color', 'surince' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-meta .item a',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'blog_entry_meta_item_link_color_hover',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color Hover', 'surince' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-meta .item a:hover',
				'alter' => 'color',
			),
		),
	),
);

// Blog Posts Excerpt
$this->sections['surince_blog_post_excerpt'] = array(
	'title' => esc_html__( 'Blog Post - Excerpt', 'surince' ),
	'panel' => 'surince_blog',
	'settings' => array(
		array(
			'id' => 'blog_content_style',
			'default' => 'style-2',
			'control' => array(
				'label' => esc_html__( 'Content Style', 'surince' ),
				'type' => 'select',
				'choices' => array(
					'style-1' => esc_html__( 'Normal', 'surince' ),
					'style-2' => esc_html__( 'Excerpt', 'surince' ),
				),
			),
		),
		array(
			'id' => 'blog_excerpt_length',
			'default' => '50',
			'control' => array(
				'label' => esc_html__( 'Excerpt length', 'surince' ),
				'type' => 'text',
				'desc' => esc_html__( 'This option only apply for Content Style: Excerpt.', 'surince' )
			),
		),
		array(
			'id' => 'blog_excerpt_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Margin', 'surince' ),
				'description' => esc_html__( 'Top Right Bottom Left. Example: 0 0 30px 0.', 'surince' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-excerpt',
				'alter' => 'margin',
			),
		),
		array(
			'id' => 'blog_excerpt_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'surince' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-excerpt',
				'alter' => 'color',
			),
		),
	),
);

// Blog Posts Read More
$this->sections['surince_blog_post_read_more'] = array(
	'title' => esc_html__( 'Blog Post - Read More', 'surince' ),
	'panel' => 'surince_blog',
	'settings' => array(
		array(
			'id' => 'blog_entry_button_read_more_text',
			'default' => esc_html__( 'Read More', 'surince' ),
			'control' => array(
				'label' => esc_html__( 'Button Text', 'surince' ),
				'type' => 'text',
			),
		),
	),
);

