<?php
/**
 * Bottom Bar setting for Customizer
 *
 * @package surince
 * @version 3.8.9
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Bottom Bar General
$this->sections['surince_bottombar_general'] = array(
	'title' => esc_html__( 'General', 'surince' ),
	'panel' => 'surince_bottombar',
	'settings' => array(
		array(
			'id' => 'bottom_bar',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Enable', 'surince' ),
				'type' => 'checkbox',
				'active_callback' => 'surince_cac_footer_basic'
			),
		),
		array(
			'id' => 'bottom_copyright',
			'transport' => 'postMessage',
			'default' => '&copy; Copyrights, 2023 Company.com',
			'control' => array(
				'label' => esc_html__( 'Copyright', 'surince' ),
				'type' => 'surince_textarea',
				'active_callback' => 'surince_cac_has_bottombar',
			),
		),
		array(
			'id' => 'bottom_padding',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'text',
				'label' => esc_html__( 'Padding', 'surince' ),
				'description' => esc_html__( 'Top Right Bottom Left.', 'surince' ),
				'active_callback'=> 'surince_cac_has_bottombar',
			),
			'inline_css' => array(
				'target' => '#bottom .bottom-bar-inner-wrap',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'bottom_background',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'surince' ),
				'active_callback'=> 'surince_cac_has_bottombar',
			),
			'inline_css' => array(
				'target' => '#bottom',
				'alter' => 'background',
			),
		),
		array(
			'id' => 'bottom_background_img',
			'control' => array(
				'type' => 'image',
				'label' => esc_html__( 'Background Image', 'surince' ),
				'active_callback' => 'surince_cac_has_bottombar',
			),
		),
		array(
			'id' => 'bottom_background_img_style',
			'default' => 'repeat',
			'control' => array(
				'label' => esc_html__( 'Background Image Style', 'surince' ),
				'type'  => 'image',
				'type'  => 'select',
				'choices' => array(
					''             => esc_html__( 'Default', 'surince' ),
					'cover'        => esc_html__( 'Cover', 'surince' ),
					'center-top'        => esc_html__( 'Center Top', 'surince' ),
					'fixed-top'    => esc_html__( 'Fixed Top', 'surince' ),
					'fixed'        => esc_html__( 'Fixed Center', 'surince' ),
					'fixed-bottom' => esc_html__( 'Fixed Bottom', 'surince' ),
					'repeat'       => esc_html__( 'Repeat', 'surince' ),
					'repeat-x'     => esc_html__( 'Repeat-x', 'surince' ),
					'repeat-y'     => esc_html__( 'Repeat-y', 'surince' ),
				),
				'active_callback' => 'surince_cac_has_bottombar',
			),
		),
		array(
			'id' => 'bottom_color',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'surince' ),
				'active_callback'=> 'surince_cac_has_bottombar',
			),
			'inline_css' => array(
				'target' => '#bottom',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'line_color',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'color',
				'label' => esc_html__( 'Line Color', 'surince' ),
				'active_callback'=> 'surince_cac_has_bottombar',
			),
			'inline_css' => array(
				'target' => '#bottom:before',
				'alter' => 'background-color',
			),
		),
	),
);

