<?php
/**
 * Featured Title setting for Customizer
 *
 * @package surince
 * @version 3.8.9
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Featured Title General
$this->sections['surince_featuredtitle_general'] = array(
	'title' => esc_html__( 'General', 'surince' ),
	'panel' => 'surince_featuredtitle',
	'settings' => array(
		array(
			'id' => 'featured_title',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Enable', 'surince' ),
				'type' => 'checkbox',
			),
		),
		array(
			'id' => 'featured_title_style',
			'default' => 'simple',
			'control' => array(
				'label'  => esc_html__( 'Style', 'surince' ),
				'type' => 'select',
				'choices' => array(
					'simple' => esc_html__( 'Simple', 'surince' ),
					'centered' => esc_html__( 'Centered', 'surince' ),
					'modern' => esc_html__( 'Modern', 'surince' ),
				),
				'active_callback' => 'surince_cac_has_featured_title',
			),
		),
		array(
			'id' => 'featured_title_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Padding', 'surince' ),
				'description' => esc_html__( 'Example: 250px 0px 150px 0px', 'surince' ),
				'active_callback' => 'surince_cac_has_featured_title',
			),
			'inline_css' => array(
				'media_query' => '(min-width: 992px)',
				'target' => '#featured-title .inner-wrap',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'featured_title_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'surince' ),
				'active_callback' => 'surince_cac_has_featured_title',
			),
			'inline_css' => array(
				'target' => '#featured-title',
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'featured_title_background_img',
			'control' => array(
				'type' => 'image',
				'label' => esc_html__( 'Background Image', 'surince' ),
				'active_callback' => 'surince_cac_has_featured_title',
			),
		),
		array(
			'id' => 'featured_title_background_img_style',
			'default' => 'repeat',
			'control' => array(
				'label' => esc_html__( 'Background Image Style', 'surince' ),
				'type'  => 'image',
				'type'  => 'select',
				'choices' => array(
					''             => esc_html__( 'Default', 'surince' ),
					'cover'        => esc_html__( 'Cover', 'surince' ),
					'center-top'        => esc_html__( 'Center Top', 'surince' ),
					'fixed-top'    => esc_html__( 'Fixed Top', 'surince' ),
					'fixed'        => esc_html__( 'Fixed Center', 'surince' ),
					'fixed-bottom' => esc_html__( 'Fixed Bottom', 'surince' ),
					'repeat'       => esc_html__( 'Repeat', 'surince' ),
					'repeat-x'     => esc_html__( 'Repeat-x', 'surince' ),
					'repeat-y'     => esc_html__( 'Repeat-y', 'surince' ),
				),
				'active_callback' => 'surince_cac_has_featured_title',
			),
		),
	),
);

// Featured Title Headings
$this->sections['surince_featuredtitle_heading'] = array(
	'title' => esc_html__( 'Headings', 'surince' ),
	'panel' => 'surince_featuredtitle',
	'settings' => array(
		array(
			'id' => 'featured_title_heading',
			'default' => false,
			'control' => array(
				'label' => esc_html__( 'Enable', 'surince' ),
				'type' => 'checkbox',
				'active_callback' => 'surince_cac_has_featured_title',
			),
		),
		array(
			'id' => 'featured_title_heading_bottom_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Heading Bottom Margin', 'surince' ),
				'active_callback' => 'surince_cac_has_featured_title_center',
				'description' => esc_html__( 'Example: 30px.', 'surince' ),
			),
			'inline_css' => array(
				'target' => '#featured-title.centered .title-group',
				'alter' => 'margin-bottom',
			),
		),
		array(
			'id' => 'featured_title_heading_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Title Color', 'surince' ),
				'active_callback' => 'surince_cac_has_featured_title_heading',
			),
			'inline_css' => array(
				'target' => '#featured-title .main-title',
				'alter' => 'color',
			),
		),
	),
);

// Featured Title Breadcrumbs
$this->sections['surince_featuredtitle_breadcrumbs'] = array(
	'title' => esc_html__( 'Breadcrumbs', 'surince' ),
	'panel' => 'surince_featuredtitle',
	'settings' => array(
		array(
			'id' => 'featured_title_breadcrumbs',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Enable', 'surince' ),
				'type' => 'checkbox',
				'active_callback' => 'surince_cac_has_featured_title',
			),
		),
		array(
			'id' => 'featured_title_breadcrumbs_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Text Color', 'surince' ),
				'active_callback' => 'surince_cac_has_featured_title_breadcrumbs',
			),
			'inline_css' => array(
				'target' => array(
					'#featured-title #breadcrumbs',
				),
				'alter' => 'color',
			),
		),
		array(
			'id' => 'featured_title_breadcrumbs_link_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color', 'surince' ),
				'active_callback' => 'surince_cac_has_featured_title_breadcrumbs',
			),
			'inline_css' => array(
				'target' => '#featured-title #breadcrumbs a',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'featured_title_breadcrumbs_link_hover_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color: Hover', 'surince' ),
				'active_callback' => 'surince_cac_has_featured_title_breadcrumbs',
			),
			'inline_css' => array(
				'target' => '#featured-title #breadcrumbs a:hover',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'portfolio_page',
			'control' => array(
				'label'  => esc_html__( 'Projects', 'surince' ),
				'type' => 'select',
				'choices' => surince_get_pages(),
				'active_callback' => 'surince_cac_has_single_project',
			),
		),
	),
);