<?php
/**
 * Layout setting for Customizer
 *
 * @package surince
 * @version 3.8.9
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Layout Style
$this->sections['surince_layout_style'] = array(
	'title' => esc_html__( 'Layout Site', 'surince' ),
	'panel' => 'surince_layout',
	'settings' => array(
		array(
			'id' => 'site_layout_style',
			'default' => 'full-width',
			'control' => array(
				'label' => esc_html__( 'Layout Style', 'surince' ),
				'type' => 'select',
				'choices' => array(
					'full-width' => esc_html__( 'Full Width','surince' ),
					'boxed' => esc_html__( 'Boxed','surince' )
				),
			),
		),
		array(
			'id' => 'site_layout_boxed_shadow',
			'control' => array(
				'label' => esc_html__( 'Box Shadow', 'surince' ),
				'type' => 'checkbox',
				'active_callback' => 'surince_cac_has_boxed_layout',
			),
		),
		array(
			'id' => 'site_layout_wrapper_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Wrapper Margin', 'surince' ),
				'desc' => esc_html__( 'Top Right Bottom Left. Default: 30px 0px 30px 0px.', 'surince' ),
				'active_callback' => 'surince_cac_has_boxed_layout',
			),
			'inline_css' => array(
				'target' => '.site-layout-boxed #wrapper',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'wrapper_background_color',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Outer Background Color', 'surince' ),
				'type' => 'color',
				'active_callback' => 'surince_cac_has_boxed_layout',
			),
			'inline_css' => array(
				'target' => '.site-layout-boxed #wrapper',
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'wrapper_background_img',
			'control' => array(
				'label' => esc_html__( 'Outer Background Image', 'surince' ),
				'type' => 'image',
				'active_callback' => 'surince_cac_has_boxed_layout',
			),
		),
		array(
			'id' => 'wrapper_background_img_style',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Outer Background Image Style', 'surince' ),
				'type'  => 'image',
				'type'  => 'select',
				'choices' => array(
					''             => esc_html__( 'Default', 'surince' ),
					'cover'        => esc_html__( 'Cover', 'surince' ),
					'center-top'        => esc_html__( 'Center Top', 'surince' ),
					'fixed-top'    => esc_html__( 'Fixed Top', 'surince' ),
					'fixed'        => esc_html__( 'Fixed Center', 'surince' ),
					'fixed-bottom' => esc_html__( 'Fixed Bottom', 'surince' ),
					'repeat'       => esc_html__( 'Repeat', 'surince' ),
					'repeat-x'     => esc_html__( 'Repeat-x', 'surince' ),
					'repeat-y'     => esc_html__( 'Repeat-y', 'surince' ),
				),
				'active_callback' => 'surince_cac_has_boxed_layout',
			),
		),
	),
);

// Layout Position
$this->sections['surince_layout_position'] = array(
	'title' => esc_html__( 'Layout Position', 'surince' ),
	'panel' => 'surince_layout',
	'settings' => array(
		array(
			'id' => 'site_layout_position',
			'default' => 'sidebar-right',
			'control' => array(
				'label' => esc_html__( 'Site Layout Position', 'surince' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'surince' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'surince' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'surince' ),
				),
				'desc' => esc_html__( 'Specify layout for all pages on website. (e.g. pages, blog posts, single post, archives, etc ). Single page can override this setting in Page Settings elementor when edit.', 'surince' )
			),
		),
		array(
			'id' => 'custom_page_layout_position',
			'default' => 'no-sidebar',
			'control' => array(
				'label' => esc_html__( 'Custom Page Layout Position', 'surince' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'surince' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'surince' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'surince' ),
				),
				'desc' => esc_html__( 'Specify layout for all custom pages.', 'surince' )
			),
		),
		array(
			'id' => 'single_post_layout_position',
			'default' => 'sidebar-right',
			'control' => array(
				'label' => esc_html__( 'Single Post Layout Position', 'surince' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'surince' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'surince' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'surince' ),
				),
				'desc' => esc_html__( 'Specify layout for all single post pages.', 'surince' )
			),
		),
		array(
			'id' => 'single_project_layout_position',
			'default' => 'no-sidebar',
			'control' => array(
				'label' => esc_html__( 'Single Project Layout Position', 'surince' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'surince' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'surince' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'surince' ),
				),
				'desc' => esc_html__( 'Specify layout for all single project pages.', 'surince' ),
				'active_callback' => 'surince_cac_has_single_project',
			),
		),
		array(
			'id' => 'single_service_layout_position',
			'default' => 'no-sidebar',
			'control' => array(
				'label' => esc_html__( 'Single Service Layout Position', 'surince' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'surince' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'surince' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'surince' ),
				),
				'desc' => esc_html__( 'Specify layout for all single service pages.', 'surince' ),
				'active_callback' => 'surince_cac_has_single_service',
			),
		),
		array(
			'id' => 'give_forms_layout_position',
			'default' => 'sidebar-right',
			'control' => array(
				'label' => esc_html__( 'Give Forms Layout Position', 'surince' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'surince' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'surince' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'surince' ),
				),
				'desc' => esc_html__( 'Specify layout for all Give Forms.', 'surince' ),
				'active_callback' => 'surince_cac_has_give_forms',
			),
		),
	),
);

// Layout Widths
$this->sections['surince_layout_widths'] = array(
	'title' => esc_html__( 'Layout Widths', 'surince' ),
	'panel' => 'surince_layout',
	'settings' => array(
		array(
			'id' => 'site_desktop_container_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Container', 'surince' ),
				'type' => 'text',
				'desc' => esc_html__( 'Default: 1170px', 'surince' ),
			),
			'inline_css' => array(
				'target' => array( 
					'.site-layout-full-width .surince-container',
					'.site-layout-boxed #page'
				),
				'alter' => 'width',
			),
		),
		array(
			'id' => 'left_container_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Content', 'surince' ),
				'type' => 'text',
				'desc' => esc_html__( 'Example: 66%', 'surince' ),
			),
			'inline_css' => array(
				'target' => '#site-content',
				'alter' => 'width',
			),
		),
		array(
			'id' => 'sidebar_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Sidebar', 'surince' ),
				'type' => 'text',
				'desc' => esc_html__( 'Example: 28%', 'surince' ),
			),
			'inline_css' => array(
				'target' => '#sidebar',
				'alter' => 'width',
			),
		),
	),
);