<?php
/**
 * Services setting for Customizer
 *
 * @package surince
 * @version 3.8.9
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Service General
$this->sections['surince_services_general'] = array(
	'title' => esc_html__( 'General', 'surince' ),
	'panel' => 'surince_services',
	'settings' => array(
		array(
			'id' => 'surince_service_single_featured_title',
			'control' => array(
				'type' => 'surince-heading',
				'label' => esc_html__( 'Feature Title', 'surince' ),
			),
		),
		array(
			'id' => 'service_single_featured_title',
			'default' =>  '',
			'control' => array(
				'label' => esc_html__( 'Title', 'surince' ),
				'type' => 'text',
				'description' => esc_html__( 'If empty, it will be blog title by default.', 'surince' ),
			),
		),
		array(
			'id' => 'service_single_featured_title_background_img',
			'control' => array(
				'type' => 'image',
				'label' => esc_html__( 'Single Service: Featured Title Background', 'surince' ),
			),
		)
	),
);