<?php
/**
 * Shop setting for Customizer
 *
 * @package surince
 * @version 3.8.9
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Main Shop
$this->sections['surince_shop_general'] = array(
	'title' => esc_html__( 'Main Shop', 'surince' ),
	'panel' => 'surince_shop',
	'settings' => array(
		array(
			'id' => 'shop_layout_position',
			'default' => 'no-sidebar',
			'control' => array(
				'label' => esc_html__( 'Shop Layout Position', 'surince' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'surince' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'surince' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'surince' ),
				),
				'desc' => esc_html__( 'Specify layout for main shop page.', 'surince' ),
				'active_callback' => 'surince_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_featured_title',
			'default' => esc_html__( 'Our Shop', 'surince' ),
			'control' => array(
				'label' => esc_html__( 'Shop: Featured Title', 'surince' ),
				'type' => 'surince_textarea',
				'active_callback' => 'surince_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_featured_title_background_img',
			'control' => array(
				'type' => 'image',
				'label' => esc_html__( 'Shop: Featured Title Background', 'surince' ),
				'active_callback' => 'surince_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_products_per_page',
			'default' => 6,
			'control' => array(
				'label' => esc_html__( 'Products Per Page', 'surince' ),
				'type' => 'number',
				'active_callback' => 'surince_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_columns',
			'default' => '3',
			'control' => array(
				'label' => esc_html__( 'Shop Columns', 'surince' ),
				'type' => 'select',
				'choices' => array(
					'2' => '2',
					'3' => '3',
					'4' => '4',
				),
				'active_callback' => 'surince_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_item_bottom_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Item Bottom Margin', 'surince' ),
				'description' => esc_html__( 'Example: 30px.', 'surince' ),
				'active_callback' => 'surince_cac_has_woo',
			),
			'inline_css' => array(
				'target' => '.products li',
				'alter' => 'margin-top',
			),
		),
	),
);

// Single Shop
$this->sections['surince_single_shop_general'] = array(
	'title' => esc_html__( 'Single Shop', 'surince' ),
	'panel' => 'surince_shop',
	'settings' => array(
		array(
			'id' => 'shop_single_layout_position',
			'default' => 'no-sidebar',
			'control' => array(
				'label' => esc_html__( 'Shop Single Layout Position', 'surince' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'surince' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'surince' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'surince' ),
				),
				'desc' => esc_html__( 'Specify layout on the shop single page.', 'surince' ),
				'active_callback' => 'surince_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_single_featured_title',
			'default' => esc_html__( 'Our Shop', 'surince' ),
			'control' => array(
				'label' => esc_html__( 'Shop Single: Featured Title', 'surince' ),
				'type' => 'text',
				'active_callback' => 'surince_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_single_featured_title_background_img',
			'control' => array(
				'type' => 'image',
				'label' => esc_html__( 'Shop Single: Featured Title Background', 'surince' ),
				'active_callback' => 'surince_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_realted_columns',
			'default' => '3',
			'control' => array(
				'label' => esc_html__( 'Related Product Columns', 'surince' ),
				'type' => 'select',
				'choices' => array(
					'0' => '0',
					'2' => '2',
					'3' => '3',
					'4' => '4',
				),
				'active_callback' => 'surince_cac_has_woo',
			),
		),
	),
);