<?php
/**
 * Gets all theme mods and stores them in an easily accessable global var to limit DB requests
 *
 * @package surince
 * @version 3.8.9
 */

global $surince_theme_mods;
$surince_theme_mods = get_theme_mods();

// Returns theme mod from global var
function surince_get_mod( $id, $default = '' ) {

	// Return get_theme_mod on customize_preview
	if ( is_customize_preview() ) {
		return get_theme_mod( $id, $default );
	}
   
	// Get global object
	global $surince_theme_mods;

	// Return data from global object
	if ( ! empty( $surince_theme_mods ) ) {

		// Return value
		if ( isset( $surince_theme_mods[$id] ) ) {
			return $surince_theme_mods[$id];
		} 
		else {
			return $default;
		}
	}

	// Global object not found return using get_theme_mod
	else {
		return get_theme_mod( $id, $default );
	}
}

// Returns global mods
function surince_get_mods() {
	global $surince_theme_mods;
	return $surince_theme_mods;
}