<?php
// Custom classes to body tag
function surince_body_classes() {
	$classes[] = '';

	// Elementor
	if ( class_exists( '\Elementor\Plugin' ) ) {
		if ( \Elementor\Plugin::$instance->preview->is_preview_mode() ) {
			$classes[] = 'elementor-preview';
		}
	}
	
	if ( get_post_type() == 'elementor_library' )
		$classes[] = 'elementor-template';

	// Get layout position
	$classes[] = surince_layout_position();
	$layout_position = surince_layout_position();
	if ( ! is_page() && $layout_position != 'no-sidebar' && ! is_active_sidebar( 'sidebar-blog' ) )
		$classes[] = 'blog-empty-widget';

	if ( is_page() && $layout_position != 'no-sidebar' && ! is_active_sidebar( 'sidebar-page' ) )
		$classes[] = 'page-empty-widget';

	// Get layout style
	$layout_style = surince_get_mod( 'site_layout_style', 'full-width' );
	$classes[] = 'site-layout-'. $layout_style;


	if ( is_page() ) $classes[] = 'is-page';

	if ( is_page_template( 'templates/page-onepage.php' ) )
		$classes[] = 'one-page';

	// Add classes for Woo pages
	if ( class_exists( 'woocommerce' ) ) {
		if ( surince_is_woocommerce_page() )
			$classes[] = 'woocommerce-page';

		if ( is_account_page() )
			$classes[] = 'woocommerce-account';

		if ( surince_is_woocommerce_shop() )
			$classes[] = 'main-shop-page';

		if ( surince_is_woocommerce_shop() || surince_is_woocommerce_archive_product() ) {
			$shop_cols = surince_get_mod( 'shop_columns', '3' );
			$classes[] = 'shop-col-'. $shop_cols;
		}
	}

	// Add class for search page
	if ( is_search() )
		$classes[] = 'search-page';

	// Boxed Layout dropshadow
	if ( 'boxed' == $layout_style && surince_get_mod( 'site_layout_boxed_shadow' ) )
		$classes[] = 'box-shadow';

	if ( surince_get_mod( 'header_search_icon' ) )
		$classes[] = 'header-simple-search';

	if ( is_singular( 'post' ) )
		$classes[] = 'is-single-post';

	if ( is_singular( 'project' ) )
		$classes[] = 'page-single-project';

	if ( is_singular( 'service' ) )
		$classes[] = 'page-single-service';

	if ( surince_get_mod( 'blog_single_related', false ) )
		$classes[] = 'has-related-post';

	if ( surince_get_mod( 'project_related', false ) )
		$classes[] = 'has-related-project';

	if ( ! is_active_sidebar( 'sidebar-footer-1' ) &&
		! is_active_sidebar( 'sidebar-footer-2' ) &&
		! is_active_sidebar( 'sidebar-footer-3' ) &&
		! is_active_sidebar( 'sidebar-footer-4' ) &&
		! is_active_sidebar( 'sidebar-footer-5' ))
		$classes[] = 'footer-no-widget';

	// CPT pages
	if ( is_singular( 'header' ) )
		$classes[] = 'page-header-single';
	
	if ( is_singular( 'footer' ) )
		$classes[] = 'page-footer-single';

	if ( is_singular( 'give_forms' ) )
		$classes[] = 'page-give-forms';
	
	if ( is_singular( 'event_listing' ) )
		$classes[] = 'single_event_listing';	

	// Hide related product
	$column = surince_get_mod( 'shop_realted_columns', 3 );
	if ($column == 0)
		$classes[] = 'shop-no-related-product';

	// Footer Fixed
	if ( surince_get_elementor_option('footer_fixed') == 'yes' )
		$classes[] = 'footer-fixed';

	// User Log in
	if ( is_user_logged_in() ) 
		$classes[] = 'logged-in';

	// Return classes
	return $classes;
}
add_filter( 'body_class', 'surince_body_classes' );

// Elementor Setup
function surince_get_elementor_option_setup() {
	if ( class_exists( '\Elementor\Plugin' ) ) {
		// Add Surince Color Set
		$surince_color = [
			0 => [
				'_id' 	=> 'surince_primary',
				'title'	=> esc_html__( 'Surince Primary', 'surince' ),
				'color'	=> '#0D0D3F'
			],
			1 => [
				'_id'	=> 'surince_text',
				'title'	=> esc_html__( 'Surince Text', 'surince' ),
				'color'	=> '#7F7F88'
			],
			2 => [
				'_id'	=> 'surince_accent',
				'title'	=> esc_html__( 'Surince Accent', 'surince' ),
				'color'	=> '#2E3BA6'
			],
			3 => [
				'_id'	=> 'surince_accent_2',
				'title'	=> esc_html__( 'Surince Accent 2', 'surince' ),
				'color'	=> '#28B79A'
			],
			4 => [
				'_id'	=> 'surince_border',
				'title'	=> esc_html__( 'Surince Border', 'surince' ),
				'color'	=> '#DBD9E5'
			],
			5 => [
				'_id'	=> 'surince_light',
				'title'	=> esc_html__( 'Surince Light', 'surince' ),
				'color'	=> '#EEEEF4'
			]
		];

		// Color
		$kit = \Elementor\Plugin::$instance->kits_manager->get_active_kit_for_frontend();
		$colors = $kit->get_settings_for_display( 'custom_colors' );

		$first_time = true;
		
		foreach($surince_color as $arr1) {
			$found = false;
			foreach( $colors as $key => $arr2 ) {
				if ( $arr1['_id'] == $arr2['_id'] ) {
					$found = true;
					$first_time = false;
				}
			}

			if ( !$found ) {
				$colors[] = $arr1;
			}
		}

		if ( $first_time ) {
			// Update Colors
			\Elementor\Plugin::$instance->kits_manager->update_kit_settings_based_on_option( 'custom_colors', $colors);

			// Update Typography
			$idx = 0;
			$typos = $kit->get_settings_for_display( 'system_typography' );
			foreach($typos as $item) {
				switch ( $item['_id'] ) {
					case 'primary':
						$typos[$idx]['typography_font_family'] = 'Manrope';
						$typos[$idx]['typography_font_weight'] = '800';
						break;
					case 'secondary':
						$typos[$idx]['typography_font_family'] = 'Manrope';
						$typos[$idx]['typography_font_weight'] = '800';
						break;
					case 'text':
						$typos[$idx]['typography_font_family'] = 'Manrope';
						$typos[$idx]['typography_font_weight'] = '500';
						break;
					case 'accent':
						$typos[$idx]['typography_font_family'] = 'Manrope';
						$typos[$idx]['typography_font_weight'] = '500';
						break;
					default:
						return;
				}
				$idx++;
			}
			\Elementor\Plugin::$instance->kits_manager->update_kit_settings_based_on_option( 'system_typography', $typos);

			// Update Layout
			$layout = $kit->get_settings_for_display( 'container_width' );
			$layout['size'] = '1200';
			\Elementor\Plugin::$instance->kits_manager->update_kit_settings_based_on_option( 'container_width', $layout);

			// Container Padding
			$padding = $kit->get_settings_for_display( 'container_padding' );
			$padding['top'] = $padding['right'] = $padding['left'] = $padding['bottom'] = 0; 
			\Elementor\Plugin::$instance->kits_manager->update_kit_settings_based_on_option( 'container_padding', $padding);

			// Update Widgets Space
			$widgets_space = $kit->get_settings_for_display( 'space_between_widgets' );
			$widgets_space['size'] = 0;
			$widgets_space['column'] = 0;
			$widgets_space['row'] = 0;
			\Elementor\Plugin::$instance->kits_manager->update_kit_settings_based_on_option( 'space_between_widgets', $widgets_space);

			// Disable Light Box
			$lightbox = $kit->get_settings_for_display( 'global_image_lightbox' );
			$lightbox = 'no';
			\Elementor\Plugin::$instance->kits_manager->update_kit_settings_based_on_option( 'global_image_lightbox', $lightbox);

			// Update Post Support
			$cpt_support = get_option( 'elementor_cpt_support' );
	
			//check if option DOESN'T exist in db
			if( ! $cpt_support ) {
			    $cpt_support = [ 'page', 'post', 'header', 'footer', 'project', 'service', 'event_listing' ]; 
			    update_option( 'elementor_cpt_support', $cpt_support ); 
			}

			// Disable default colors & default fonts
			$disable_default_colors = 'yes';
			$disable_default_fonts = 'yes';
			update_option( 'elementor_disable_color_schemes', $disable_default_colors ); 
			update_option( 'elementor_disable_typography_schemes', $disable_default_fonts ); 

			// Switch Editor Load Method
			update_option( 'elementor_editor_break_lines', 1 ); 

		}
	}
}
add_action( 'after_switch_theme', 'surince_get_elementor_option_setup' );
add_action( 'elementor/init', 'surince_get_elementor_option_setup' );

// Remove products and pages results from the search form widget
function surince_custom_search_query( $query ) {
	if ( is_admin() || ! $query->is_main_query() )
		return;

    $post_types_to_remove = array('header', 'footer');
    $exclude = surince_get_mod('search_query', '');
    if ($exclude !== '') {
        $post_types_to_remove = array_merge( $post_types_to_remove, explode(',', $exclude));
    }
	if ( $query->is_search() ) {
    	$in_search_post_types = get_post_types( array( 'exclude_from_search' => false ) );

	    foreach ( $post_types_to_remove as $post_type_to_remove ) {
			if ( is_array( $in_search_post_types ) 
				&& in_array( $post_type_to_remove, $in_search_post_types ) 
			) {
				unset( $in_search_post_types[ $post_type_to_remove ] );
				$query->set( 'post_type', $in_search_post_types );
			}
	    }
	}
}
add_action( 'pre_get_posts', 'surince_custom_search_query' );

// Sets the content width in pixels, based on the theme's design and stylesheet.
function surince_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'surince_content_width', 1170 );
}
add_action( 'after_setup_theme', 'surince_content_width', 0 );

// Modifies tag cloud widget arguments to have all tags in the widget same font size.
function surince_widget_tag_cloud_args( $args ) {
	$args['largest'] = 12;
	$args['smallest'] = 12;
	$args['unit'] = 'px';

	return $args;
}
add_filter( 'widget_tag_cloud_args', 'surince_widget_tag_cloud_args' );

// Change default read more style
function surince_excerpt_more( $more ) {
	return '';
}
add_filter( 'excerpt_more', 'surince_excerpt_more', 10 );

// Custom excerpt length for posts
function surince_content_length() {
	$length = surince_get_mod( 'blog_excerpt_length', '50' );
	$length = intval( $length );

	if ( ! empty( $length ) || $length != 0 )
		return $length;
}
add_filter( 'excerpt_length', 'surince_content_length', 999 );

// Prevent page scroll when clicking the more link
function surince_remove_more_link_scroll( $link ) {
	$link = preg_replace( '|#more-[0-9]+|', '', $link );

	return $link;
}
add_filter( 'the_content_more_link', 'surince_remove_more_link_scroll' );

// Remove read-more link so we can custom it
function surince_remove_read_more_link() {
    return '';
}
add_filter( 'the_content_more_link', 'surince_remove_read_more_link' );

// Custom html categories widget
function cat_count_span( $link ) {
  $link = str_replace( '</a> (', '</a> <span>', $link );
  $link = str_replace( ')', '</span>', $link );
  return $link;
}
add_filter( 'wp_list_categories', 'cat_count_span' );
 

// Remove p in CF7
add_filter('wpcf7_autop_or_not', '__return_false');

// ShopEngine Affiliate 
add_filter('wpmet_author_id', function($id) { return 586; });


// Fix error Elementor when printting CSS
function surince_print_css($value) {
	if (is_customize_preview()) return false;
	return $value;
}
add_filter( 'elementor/frontend/builder_content/before_print_css', 'surince_print_css' );
